﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
/*
 * @brief 사용자가 동영상 기능(로드/재생)호출 시, 이벤트 처리를 위한 이벤트 핸들러 모음
 */
namespace hiveAdiz
{
    public class AdizCallbackManager : MonoBehaviour
    {
        // Common
        public static CommonHandlers sdkInitHandler;

        public static CommonHandlers commonResultHandler;

        public static string defaultInterstitialKey = "";
        public static string defaultBannerKey = "";
        public static string defaultNativeKey = "";
        public static string defaultRewardedKey = "";
        public static string defaultRewardedInterstitialKey = "";
        public static string defaultAppOpenKey = "";

        // Callback handler
        public static Dictionary<string, AdEventHandlers> callbackHandler = new Dictionary<string, AdEventHandlers>();

        public void Start() {
            // AdizLogger.d("AdizCallbackManager Start");
        }

        public void Update() {
            // AdizLogger.d("AdizCallbackManager Update");
        }

        ~AdizCallbackManager() {
            sdkInitHandler = null;
            callbackHandler = null;
        }
 
        void onSdkInitialize(string jsonString) {
            // AdizLogger.d("AdizCallbackManager onSdkInitialize json "+jsonString);

            JSONObject resJsonObject = new JSONObject (jsonString);

            JSONObject jsonArray = resJsonObject.GetField ("keys");
            
            if (jsonArray != null && jsonArray.count > 0) {
                
                List<JSONObject> jsonList = jsonArray.list;

                foreach (JSONObject jsonItem in jsonList) {
                    // AdizLogger.d("onSdkInitialize jsonItem "+jsonItem); // jsonItem {"id":"5","key":"hive-ad-easy-pub-655c6f99747fa","form":"rewarded_interstitial","is_default":true}
                    bool isDefault = false;
                    jsonItem.GetField(ref isDefault, "is_default");
                    // AdizLogger.d("onSdkInitialize isDefault "+isDefault);

                    if(isDefault) {
                        string key = null;
                        jsonItem.GetField(ref key, "key");

                        string form = null;
                        jsonItem.GetField(ref form, "form");
                        
                        setDefaultAdKey(form,   key);
                    }
                }
            
            } else {
                AdizLogger.d("onSdkInitialize jsonString is empty.");
            }

            int errorCode = -1;
            resJsonObject.GetField(ref errorCode, "error_code");

            string errorMessage = "";
            resJsonObject.GetField(ref errorMessage, "error_message");

            if(sdkInitHandler != null) {
                sdkInitHandler.onResult(new AdizError(errorCode, errorMessage), jsonString);
            }
        }

        void onLoad(string jsonString) {
            AdizLogger.d("AdizCallbackManager onLoad. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onLoad type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];
                if(cb.onAdLoad != null) cb.onAdLoad();
			}
        }

        void onFail(string jsonString) {
            AdizLogger.d("AdizCallbackManager onFail. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            int errorCode = -1;
            json.GetField(ref errorCode, "error_code");

            string errorMessage = "";
            json.GetField(ref errorMessage, "error_message");

            AdizLogger.d("AdizCallbackManager onFail errorCode : " + errorCode + " errorMessage : " + errorMessage);

            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onFail type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];	
                if(cb.onAdFail != null) cb.onAdFail(new AdizError(errorCode, errorMessage));
			}
        }

        void onShow(string jsonString) {
            AdizLogger.d("AdizCallbackManager onShow. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onShow type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];	
                if(cb.onAdShow != null) cb.onAdShow();
			}
        }

        void onClick(string jsonString) {
            AdizLogger.d("AdizCallbackManager onClick. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onClick type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];	
                if(cb.onAdClick != null) cb.onAdClick();
			}
        }

        void onClose(string jsonString) {
            AdizLogger.d("AdizCallbackManager onClose. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onClose type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];
                if(cb.onAdClose != null) cb.onAdClose();
			}
        }

        void onPaidEvent(string jsonString) {
            AdizLogger.d("AdizCallbackManager onPaidEvent. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            double revenue = 0.0;
            json.GetField(ref revenue, "revenue");
            
            string currency = "USD";
            json.GetField(ref currency, "currency");
            
            AdRevenueData adRevenueData = new AdRevenueData(revenue, currency);
            
            string type = null;
            json.GetField(ref type, "type");
            
            string key = null;
            json.GetField(ref key, "key");
            
            AdizLogger.d("AdizCallbackManager onPaidEvent type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];
                
                if(cb.onAdPaidEvent != null) cb.onAdPaidEvent(adRevenueData);
			} else {
                AdizLogger.d("AdizCallbackManager onPaidEvent 77");
            }
        }

        void onRewarded(string jsonString) {
            AdizLogger.d("AdizCallbackManager onRewarded. jsonString : " + jsonString);
            JSONObject json = new JSONObject(jsonString);
            
            string itemType = "";
            json.GetField(ref itemType, "item_type");

            int itemAmount = 0;
            json.GetField(ref itemAmount, "item_amount");

            RewardItem rewardItem = new RewardItem(itemType, itemAmount);

            string type = null;
            json.GetField(ref type, "type");

            string key = null;
            json.GetField(ref key, "key");

            AdizLogger.d("AdizCallbackManager onRewarded type : " + type + " key : " + key);

            if(callbackHandler.ContainsKey(key)) {
				AdEventHandlers cb = callbackHandler[key];	
                if(cb.onAdReward != null) cb.onAdReward(rewardItem);
			}
        }

        void onCommonResult(string jsonString) {
            // AdizLogger.d("AdizCallbackManager onCommonResult json "+jsonString);

            JSONObject resJsonObject = new JSONObject (jsonString);

            int errorCode = -1;
            resJsonObject.GetField(ref errorCode, "error_code");

            string errorMessage = "";
            resJsonObject.GetField(ref errorMessage, "error_message");

            if(commonResultHandler != null) {
                commonResultHandler.onResult(new AdizError(errorCode, errorMessage), null);
            }
        }

        private void setDefaultAdKey(string adType, string adKey) {

            // AdizLogger.d("setDefaultAdKey adType : "+adType+" adKey : "+adKey);

            switch(adType) {
                case "banner":
                    defaultBannerKey = adKey;
                    break;
                case "interstitial":
                    defaultInterstitialKey = adKey;
                    break;
                case "native":
                    defaultNativeKey = adKey;
                    break;
                case "rewarded":
                    defaultRewardedKey = adKey;
                    break;
                case "rewarded_interstitial":
                    defaultRewardedInterstitialKey = adKey;
                    break;
                case "app_open":
                    defaultAppOpenKey = adKey;
                    break;
            }
        }
    }

}